function [output]  = fct_negative_alpha_LSQ_max(NEGALPHAinput);
    % solve the problem as non-negative least squares
    % introduce variable y = 1-x, impose y>=0 
    % impose a large penalty on violating y=1-x
    
    lambda0 = 1;    % if lambda0 exists, it is overwritten below; if not, then it is 1
    mm_mat = fieldnames(NEGALPHAinput);
    for ii = 1 : length(mm_mat)
        eval([cell2mat(mm_mat(ii)) '= NEGALPHAinput.(cell2mat(mm_mat(ii)));']);
    end

    % g_vec_plus,mu_vec_plus,sigma_vec_plus -- distribution under mu>0
    % p1 = prob. t1 < T1
    % p2 = prob. of t2<TU given t1<TU
    
    N = length(g_vec_plus);
    alpha_beta_vec = mu_vec_plus./sigma_vec_plus.^2 ;   
    FTplus  = zeros(N,1); 
    FTminus = zeros(N,1);
    
    for k=1:N
        mu = mu_vec_plus(k);
        sigma = sigma_vec_plus(k);
        FTplus(k,1)  = fct_CDF_F_capped(TU,mu,sigma);
        FTminus(k,1) = exp(-2*alpha_beta_vec(k))*FTplus(k,1);
        FTminus(k,1) = max(0.5*10^(-3), FTminus(k,1));        
    end

    K1 = FTplus'*g_vec_plus;
    K2 = (FTplus.^2)'*g_vec_plus;   
    K3 = (FTplus.^2./FTminus)'*g_vec_plus;  
    K4 = (FTplus.^2./FTminus.^2)'*g_vec_plus;  
    lb = zeros(N,1);
    ub = ones(N,1);

    % NON-NEGATIVE LEAST SQUARES
    Aeq0 = lambda0*g_vec_plus.*weights;
    beq0 = lambda0*sum(g_vec_plus.*weights);
    % constraints
    Aeq1 = lambda1*(-FTplus + FTplus.^2./FTminus + p1 - p1*(FTplus./FTminus).^2).*g_vec_plus;
    beq1 = lambda1*(-K1 + p1);
    Aeq2 = lambda2*(p2*(-FTplus + FTplus.^2./FTminus).*g_vec_plus);
    beq2 = lambda2*(K2 - p2*K1);      
%     % objective function
%     Aeq0 = g_vec_plus.*weights;
%     beq0 = 0;
%     % constraints
%     Aeq1 = lambda1*(-FTplus + FTplus.^2./FTminus + p1 - p1*(FTplus./FTminus).^2).*g_vec_plus;
%     beq1 = lambda1*(K3 - p1*K4);
%     Aeq2 = lambda2*(p2*(FTplus - FTplus.^2./FTminus).*g_vec_plus);
%     beq2 = lambda2*(K2 - p2*K3);   
    % constraint x <=1
    Aeq3 = lambda3*eye(N);
    beq3 = lambda3*ones(N,1);
    % all together
    Aeq = [Aeq0' zeros(1,N);...
           Aeq1' zeros(1,N);...
           Aeq2' zeros(1,N);...
           [Aeq3 Aeq3]];
    beq = [beq0;beq1;beq2;beq3];
    
    
    options = optimset('TolFun',1e-10,'TolX',1e-10);    
    xx = lsqnonneg(Aeq,beq,options);        
    x = xx(1:N);
    output.objf = Aeq0'*x;
    if size(x,1)*size(x,2)>0
        output.flipped = x'*g_vec_plus;
    end
    output.x = x;
    output.xx= xx(N+1:end);
    
    % NEW DISTRIBUTION
    err  = 10^(-10);
    sel  = (x > err) & (x<1-err);
    sel1 = (x>1-err);
    sel0 = (x < err);

    mu_vec_p1 = mu_vec_plus(sel0);
    mu_vec_p2 = -mu_vec_plus(sel1);
    mu_vec_p3 = mu_vec_plus(sel);
    mu_vec_p4 = -mu_vec_plus(sel);
    sigma_vec_p1 = sigma_vec_plus(sel0);
    sigma_vec_p2 = sigma_vec_plus(sel1);
    sigma_vec_p3 = sigma_vec_plus(sel);
    sigma_vec_p4 = sigma_vec_plus(sel);
    g_vec_p1 = g_vec_plus(sel0);
    g_vec_p2 = g_vec_plus(sel1).*(FTplus(sel1)./FTminus(sel1)).^2;
    g_vec_p3 = g_vec_plus(sel).*(1-x(sel));
    g_vec_p4 = g_vec_plus(sel).*x(sel).*(FTplus(sel)./FTminus(sel)).^2;

    g_vec = [g_vec_p1; g_vec_p2; g_vec_p3;g_vec_p4];
    output.g_vec  = g_vec/sum(g_vec);
    output.mu_vec = [mu_vec_p1;mu_vec_p2;mu_vec_p3;mu_vec_p4];
    output.sigma_vec = [sigma_vec_p1;sigma_vec_p2;sigma_vec_p3;sigma_vec_p4];
    
    output.neg_share = sum(output.g_vec(output.mu_vec<0));       

    % CHECK THE CONTRAINTS
    %disp('===============================================================')
    FT_new = zeros(length( output.g_vec),1);
    for k=1:length( output.g_vec)
        mu          = output.mu_vec(k);
        sigma       = output.sigma_vec(k);
        FT_new(k,1) = fct_CDF_F_capped(TU,mu,sigma); 
    end    
    
    output.p1_est = FT_new'*output.g_vec;
    output.p2_est = sum(FT_new.^2.*output.g_vec)/sum(FT_new.*output.g_vec);
    %disp('==============================================================='

    output.check = (min(xx)>=0) & (max(xx)<1.1);

return

